/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.keywords;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private static ConcurrentHashMap<PatternAndOptions, Pattern> cachedPatterns;
    public static final int MULTILINE = 8;
    public static final int CASE_INSENSITIVE = 2;

    private static Pattern getPattern(String pattern, int options) {
        PatternAndOptions po;
        Pattern p;
        if (cachedPatterns == null) {
            cachedPatterns = new ConcurrentHashMap();
        }
        if ((p = cachedPatterns.get(po = new PatternAndOptions(pattern, options))) == null) {
            p = Pattern.compile(pattern, options);
            cachedPatterns.put(po, p);
            if (cachedPatterns.size() > 100) {
                Iterator<Map.Entry<PatternAndOptions, Pattern>> it = cachedPatterns.entrySet().iterator();
                int i = 0;
                while (i < 25) {
                    it.next();
                    it.remove();
                    ++i;
                }
            }
        }
        return p;
    }

    public static boolean IsMatch(String Pattern2, String Text) {
        return Regex.IsMatch2(Pattern2, 0, Text);
    }

    public static boolean IsMatch2(String Pattern2, int Options, String Text) {
        return Regex.getPattern(Pattern2, Options).matcher(Text).matches();
    }

    public static String Replace(String Pattern2, String Text, String Template) {
        return Regex.Replace2(Pattern2, 0, Text, Template);
    }

    public static String Replace2(String Pattern2, int Options, String Text, String Template) {
        return Regex.getPattern(Pattern2, Options).matcher(Text).replaceAll(Template);
    }

    public static String[] Split(String Pattern2, String Text) {
        return Regex.Split2(Pattern2, 0, Text);
    }

    public static String[] Split2(String Pattern2, int Options, String Text) {
        return Regex.getPattern(Pattern2, Options).split(Text);
    }

    public static MatcherWrapper Matcher(String Pattern2, String Text) {
        return Regex.Matcher2(Pattern2, 0, Text);
    }

    public static MatcherWrapper Matcher2(String Pattern2, int Options, String Text) {
        MatcherWrapper mw = new MatcherWrapper();
        mw.setObject(Regex.getPattern(Pattern2, Options).matcher(Text));
        return mw;
    }

    @BA.ShortName(value="Matcher")
    public static class MatcherWrapper
    extends AbsObjectWrapper<Matcher> {
        public boolean Find() {
            return ((Matcher)this.getObject()).find();
        }

        public String Group(int Index) {
            return ((Matcher)this.getObject()).group(Index);
        }

        public int getGroupCount() {
            return ((Matcher)this.getObject()).groupCount();
        }

        public String getMatch() {
            return ((Matcher)this.getObject()).group();
        }

        public int GetStart(int Index) {
            return ((Matcher)this.getObject()).start(Index);
        }

        public int GetEnd(int Index) {
            return ((Matcher)this.getObject()).end(Index);
        }
    }

    private static class PatternAndOptions {
        public final String pattern;
        public final int options;

        public PatternAndOptions(String pattern, int options) {
            this.pattern = pattern;
            this.options = options;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.options;
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternAndOptions other = (PatternAndOptions)obj;
            if (this.options != other.options) {
                return false;
            }
            return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
        }
    }
}

