/*
 * Decompiled with CFR 0.152.
 */
package de.amberhome.locale;

import android.content.Context;
import android.text.format.DateFormat;
import anywheresoftware.b4a.BA;
import de.amberhome.locale.AHLocale;
import de.amberhome.locale.AHTimezone;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

@BA.ShortName(value="AHDateTime")
public class AHDateTime {
    private SimpleDateFormat sdf;
    private String pattern = "yyyy-MM-dd HH:mm:ss";
    public final int DEFAULT = 2;
    public final int SHORT = 3;
    public final int MEDIUM = 2;
    public final int LONG = 1;
    public final int FULL = 0;

    public void Initialize() {
        this.sdf = new SimpleDateFormat();
        this.sdf.setTimeZone(TimeZone.getDefault());
    }

    public void Initialize2(AHLocale locale) {
        this.sdf = new SimpleDateFormat(this.pattern, locale.myLocale);
        this.sdf.setTimeZone(TimeZone.getDefault());
    }

    public void InitializeUS() {
        this.sdf = new SimpleDateFormat(this.pattern, Locale.US);
        this.sdf.setTimeZone(TimeZone.getDefault());
    }

    public void setPattern(String pattern) {
        this.sdf.applyPattern(pattern);
    }

    public String getPattern() {
        return this.sdf.toPattern();
    }

    public void setLenient(boolean value) {
        this.sdf.setLenient(value);
    }

    public boolean getLenient() {
        return this.sdf.isLenient();
    }

    public String Format(long ticks) {
        Date mydate = new Date(ticks);
        return this.sdf.format(mydate);
    }

    public long Parse(String date) {
        try {
            return this.sdf.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse date string");
        }
    }

    public void setTimeZone(AHTimezone TimeZone2) {
        this.sdf.setTimeZone(TimeZone2.tz);
    }

    public AHTimezone getTimeZone() {
        AHTimezone tz = new AHTimezone();
        tz.Initialize_internal(this.sdf.getTimeZone());
        return tz;
    }

    public String GetDefaultTimePattern(BA ba, int Style2) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(Style2);
        return sf.toPattern();
    }

    public String GetDefaultTimePattern2(int Style2, AHLocale Locale2) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(Style2, Locale2.myLocale);
        return sf.toPattern();
    }

    public String GetShortDatePatternWithoutYear() {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3);
        return sf.toPattern().replaceAll("\\W?[Yy]+\\W?", "");
    }

    public String GetDefaultDatePattern(int Style2) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(Style2);
        return sf.toPattern();
    }

    public String GetDefaultDatePattern2(int Style2, AHLocale Locale2) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(Style2, Locale2.myLocale);
        return sf.toPattern();
    }

    public String GetDefaultDateTimePattern(int DateStyle, int TimeStyle) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(DateStyle, TimeStyle);
        return sf.toPattern();
    }

    public String GetDefaultDateTimePattern2(int DateStyle, int TimeStyle, AHLocale Locale2) {
        SimpleDateFormat sf = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(DateStyle, TimeStyle, Locale2.myLocale);
        return sf.toPattern();
    }

    public boolean is24HourFormat(BA ba) {
        return DateFormat.is24HourFormat((Context)ba.context);
    }
}

