/*
 * Decompiled with CFR 0.152.
 */
package de.amberhome.locale;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import java.text.DateFormatSymbols;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;

@BA.ShortName(value="AHLocale")
@BA.Version(value=1.16f)
@BA.Author(value="Markus Stipp")
public class AHLocale {
    @BA.Hide
    public Locale myLocale;
    private boolean isInitialized = false;

    private void init(Locale loc) {
        this.myLocale = loc;
        this.isInitialized = true;
    }

    public void Initialize() {
        this.init(Locale.getDefault());
    }

    public void Initialize2(String language) {
        this.init(new Locale(language, Locale.getDefault().getCountry()));
    }

    public void Initialize3(String language, String country) {
        this.init(new Locale(language, country));
    }

    public void InitializeUS() {
        this.init(Locale.US);
    }

    public static List getAvailableLocales() {
        List ret = new List();
        ret.Initialize();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale loc = localeArray[n2];
            if (loc.getCountry() != "" && loc.getLanguage() != "") {
                AHLocale ahloc = new AHLocale();
                ahloc.init(loc);
                ret.Add(ahloc);
            }
            ++n2;
        }
        return ret;
    }

    public Boolean getInitialized() {
        return this.isInitialized;
    }

    public String getISOCode() {
        return this.myLocale.toString();
    }

    public String getCountry() {
        return this.myLocale.getCountry();
    }

    public String getDisplayCountry() {
        return this.myLocale.getDisplayCountry(this.myLocale);
    }

    public String getEnglishCountry() {
        return this.myLocale.getDisplayCountry(Locale.US);
    }

    public String getDisplayName() {
        return this.myLocale.getDisplayName(this.myLocale);
    }

    public String getEnglishName() {
        return this.myLocale.getDisplayName(Locale.US);
    }

    public String getLanguage() {
        return this.myLocale.getLanguage();
    }

    public String getDisplayLanguage() {
        return this.myLocale.getDisplayLanguage(this.myLocale);
    }

    public String getEnglishLanguage() {
        return this.myLocale.getDisplayLanguage(Locale.US);
    }

    public String getISO3Country() {
        return this.myLocale.getISO3Country();
    }

    public String getISO3Language() {
        return this.myLocale.getISO3Language();
    }

    public String[] getISOCountries() {
        return Locale.getISOCountries();
    }

    public String[] getISOLanguages() {
        return Locale.getISOLanguages();
    }

    public String getCurrencySymbol() {
        return Currency.getInstance(this.myLocale).getSymbol();
    }

    public String getCurrencyCode() {
        return Currency.getInstance(this.myLocale).getCurrencyCode();
    }

    public int getCurrencyFractionDigits() {
        return Currency.getInstance(this.myLocale).getDefaultFractionDigits();
    }

    public String[] getAmPmStrings() {
        return new DateFormatSymbols(this.myLocale).getAmPmStrings();
    }

    public String[] getMonths() {
        return new DateFormatSymbols(this.myLocale).getMonths();
    }

    public String[] getShortMonths() {
        return new DateFormatSymbols(this.myLocale).getShortMonths();
    }

    public String[] getWeekDays() {
        return new DateFormatSymbols(this.myLocale).getWeekdays();
    }

    public String[] getShortWeekDays() {
        return new DateFormatSymbols(this.myLocale).getShortWeekdays();
    }

    public int getFirstDayOfWeek() {
        return new GregorianCalendar(this.myLocale).getFirstDayOfWeek();
    }
}

