/*
 * Decompiled with CFR 0.152.
 */
package de.amberhome.locale;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.util.Locale;

@BA.ShortName(value="AHTranslator")
public class AHTranslator {
    private Map translation = new Map();
    private Map missingTranslation = new Map();
    private String currentLanguage;
    private String currentCountry;
    private String currentFile;
    private String currentExtension = ".lng";
    private String defaultLanguage = "";

    public void Initialize(String dir, String basename) throws IOException {
        this.currentLanguage = Locale.getDefault().getLanguage();
        this.currentCountry = Locale.getDefault().getCountry();
        this.Initialize3(dir, basename, this.currentLanguage, this.currentCountry);
    }

    public void Initialize2(String dir, String basename, String language) throws IOException {
        this.Initialize3(dir, basename, language, null);
    }

    public void Initialize3(String dir, String basename, String language, String country) throws IOException {
        this.translation.Initialize();
        this.missingTranslation.Initialize();
        this.translation.Clear();
        this.missingTranslation.Clear();
        if (this.defaultLanguage != null & this.defaultLanguage != "") {
            this.LoadDefaultTranslations(dir, basename);
        }
        this.LoadTranslation(dir, basename, language, country);
    }

    private void LoadDefaultTranslations(String dir, String file) throws IOException {
        String filename = String.valueOf(file) + "_" + this.defaultLanguage + this.currentExtension;
        if (File.Exists(dir, filename)) {
            this.translation = File.ReadMap(dir, filename);
        } else if (File.Exists(File.getDirAssets(), filename)) {
            this.translation = File.ReadMap(dir, filename);
        }
    }

    private void LoadTranslation(String dir, String file, String language, String country) throws IOException {
        String filename;
        this.currentLanguage = language;
        this.currentCountry = country;
        if (country != null & country != "") {
            filename = String.valueOf(file) + "_" + language + "_" + country + this.currentExtension;
            if (!File.Exists(dir, filename)) {
                filename = String.valueOf(file) + "_" + language + this.currentExtension;
                this.currentCountry = "";
            }
        } else {
            filename = String.valueOf(file) + "_" + language + this.currentExtension;
        }
        this.currentFile = filename;
        Map localTranslation = new Map();
        localTranslation.Initialize();
        if (File.Exists(dir, filename)) {
            localTranslation = File.ReadMap(dir, filename);
        } else if (File.Exists(File.getDirAssets(), filename)) {
            localTranslation = File.ReadMap(dir, filename);
        }
        int i = 0;
        while (i < localTranslation.getSize()) {
            this.translation.Put(localTranslation.GetKeyAt(i), localTranslation.GetValueAt(i));
            ++i;
        }
    }

    public void WriteTranslation(String dir, String filename) throws IOException {
        if (this.translation.getSize() > 0) {
            File.WriteMap(dir, String.valueOf(filename) + "_" + this.currentLanguage + this.currentExtension, this.translation);
        }
        if (this.missingTranslation.getSize() > 0) {
            File.WriteMap(dir, String.valueOf(filename) + "_miss_" + this.currentLanguage + this.currentExtension, this.missingTranslation);
        }
    }

    public String GetText(String text) {
        if (this.translation.ContainsKey(text)) {
            return (String)this.translation.Get(text);
        }
        if (!this.missingTranslation.ContainsKey(text)) {
            this.missingTranslation.Put(text, text);
        }
        return text;
    }

    public String GetText2(String text, List params) {
        String myText = this.GetText(text);
        if (params.getSize() > 0) {
            String retString = myText;
            int i = 0;
            while (i < params.getSize()) {
                retString = retString.replace("{" + (i + 1) + "}", params.Get(i).toString());
                ++i;
            }
            myText = retString;
        }
        return myText;
    }

    public Map getTranslationMap() {
        return this.translation;
    }

    public void setTranslationMap(Map transmap) {
        this.translation = transmap;
    }

    public Map getMissingTranslationMap() {
        return this.missingTranslation;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String getCurrentCountry() {
        return this.currentCountry;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public String getExtension() {
        return this.currentExtension;
    }

    public void setExtension(String Extension) {
        this.currentExtension = Extension;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String Language) {
        this.defaultLanguage = Language;
    }
}

