/*
 * Decompiled with CFR 0.152.
 */
package derez.libs;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.DateTime;
import java.text.ParseException;

@BA.ShortName(value="Astro")
@BA.Author(value="Derez")
@BA.Version(value=1.23f)
public class Astro {
    public double OFFICIAL = 90.83333333;
    public double CIVIL = 96.0;
    public double NAUTICAL = 102.0;
    public double ASTRONOMICAL = 108.0;
    private double zenith = this.OFFICIAL;
    private String[] RiseSet = new String[2];
    double[][] Ma = new double[4][4];
    double F;
    double T;
    double B5;
    double L5;
    double Z0;
    double M8 = 0.0;
    double W8 = 0.0;
    double A;
    double A2 = 0.0;
    double A0;
    double D1;
    double D2 = 0.0;
    double D0;
    double V0 = 0.0;
    double V1;
    double V2 = 0.0;
    double J;
    double J3 = 0.0;
    double D5;
    double R5 = 0.0;
    double S;
    double C;
    double Z;
    double T0;
    double L;
    double M;
    double V;
    double W;
    double N;
    double U;
    double A5;
    double Z1;
    double P;
    double F0;
    double F1;
    double F2;
    double B;
    double L0;
    double L2;
    double H0;
    double H1;
    double H2;
    double E;
    double T3;
    double H3 = 0.0;
    double M3 = 0.0;
    double D;
    double Mo;
    double Y;
    double G;
    double C0;
    double P2 = Math.PI * 2;
    double DtoR = Math.PI / 180;
    double K1 = 0.26251616834300473;

    public double getZenith() {
        return this.zenith;
    }

    public void setZenith(double value) {
        this.zenith = value;
    }

    public int HebMoonPhase(int day, int month, int year) throws ParseException {
        if (day < 1 | day > 31 | month < 1 | month > 12 | year < 100) {
            return -1;
        }
        if (year == 1582 & month == 10 & day > 4 & day < 15) {
            return -1;
        }
        DateTime.setDateFormat("dd/MM/yyyy");
        long dGreg = DateTime.DateParse("01/01/2000") + 3600000L;
        dGreg = DateTime.Add(dGreg, year - 2000, month - 1, day - 1);
        return this.GToH(dGreg, day, month, year);
    }

    private int GToH(long dGreg, int gday, int gmonth, int gyear) throws ParseException {
        boolean bWhile;
        int nDateH;
        int nMonthH;
        int nMonthLen = 0;
        int nOneMolad = 29;
        int nAvrgYear = nOneMolad * 12;
        int nDays = (int)((dGreg - DateTime.DateParse("01/01/1900")) / 86400000L);
        int nYearH = (nDays += 2067025) / nAvrgYear + 1;
        long dTishrei1 = this.Tishrei1(nYearH);
        if (dTishrei1 == dGreg) {
            nMonthH = 1;
            nDateH = 1;
        } else if (dTishrei1 < dGreg) {
            while (this.Tishrei1(nYearH + 1) <= dGreg) {
                ++nYearH;
            }
        } else {
            --nYearH;
            while (this.Tishrei1(nYearH) > dGreg) {
                --nYearH;
            }
        }
        nDays = (int)((dGreg - this.Tishrei1(nYearH)) / 86400000L);
        int nLengthOfYear = this.LengthOfYear(nYearH);
        boolean bHaser = nLengthOfYear == 353 | nLengthOfYear == 383;
        boolean bShalem = nLengthOfYear == 355 | nLengthOfYear == 385;
        boolean bLeap = this.IsLeapH(nYearH);
        nMonthH = 1;
        do {
            switch (nMonthH) {
                case 1: 
                case 5: 
                case 8: 
                case 10: 
                case 12: {
                    nMonthLen = 30;
                    break;
                }
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    nMonthLen = 29;
                    break;
                }
                case 6: {
                    nMonthLen = 30;
                    break;
                }
                case 2: {
                    if (bShalem) {
                        nMonthLen = 30;
                        break;
                    }
                    nMonthLen = 29;
                    break;
                }
                case 3: {
                    nMonthLen = bHaser ? 29 : 30;
                }
            }
            if (nDays >= nMonthLen) {
                bWhile = true;
                nMonthH = bLeap | nMonthH != 5 ? ++nMonthH : (nMonthH += 2);
                nDays -= nMonthLen;
                continue;
            }
            bWhile = false;
        } while (bWhile);
        nDateH = nDays + 1;
        return nDateH;
    }

    private long Tishrei1(int nYearH) throws ParseException {
        int nMonthsSinceFirstMolad = this.MonSinceFirstMolad(nYearH);
        int nChalakim = 793 * nMonthsSinceFirstMolad;
        int nHours = (nChalakim += 204) / 1080;
        nChalakim %= 1080;
        nHours += nMonthsSinceFirstMolad * 12;
        int nDays = (nHours += 5) / 24;
        nHours %= 24;
        nDays += 29 * nMonthsSinceFirstMolad;
        int nDayOfWeek = (nDays += 2) % 7;
        if (!this.IsLeapH(nYearH) & nDayOfWeek == 3 & nHours * 1080 + nChalakim >= 9924) {
            nDayOfWeek = 5;
            nDays += 2;
        } else if (this.IsLeapH(nYearH - 1) & nDayOfWeek == 2 & nHours * 1080 + nChalakim >= 16789) {
            nDayOfWeek = 3;
            ++nDays;
        } else {
            if (nHours >= 18) {
                ++nDayOfWeek;
                nDayOfWeek %= 7;
                ++nDays;
            }
            if (nDayOfWeek == 1 | nDayOfWeek == 4 | nDayOfWeek == 6) {
                ++nDayOfWeek;
                nDayOfWeek %= 7;
                ++nDays;
            }
        }
        long dTishrei1 = DateTime.DateParse("01/01/1900");
        return dTishrei1 + (long)(nDays -= 2067025) * 86400000L;
    }

    private boolean IsLeapH(int hyear) {
        return (hyear %= 19) == 0 | hyear == 3 | hyear == 6 | hyear == 8 | hyear == 11 | hyear == 14 | hyear == 17;
    }

    private int LengthOfYear(int nYearH) throws ParseException {
        long dThisTishrei1 = this.Tishrei1(nYearH);
        long dNextTishrei1 = this.Tishrei1(nYearH + 1);
        return (int)((dNextTishrei1 - dThisTishrei1) / 86400000L);
    }

    private int MonSinceFirstMolad(int nYearH) {
        int nMonSinceFirstMolad = --nYearH / 19 * 235;
        nMonSinceFirstMolad += 12 * (nYearH %= 19);
        if (nYearH >= 17) {
            nMonSinceFirstMolad += 6;
        } else if (nYearH >= 14) {
            nMonSinceFirstMolad += 5;
        } else if (nYearH >= 11) {
            nMonSinceFirstMolad += 4;
        } else if (nYearH >= 8) {
            nMonSinceFirstMolad += 3;
        } else if (nYearH >= 6) {
            nMonSinceFirstMolad += 2;
        } else if (nYearH >= 3) {
            ++nMonSinceFirstMolad;
        }
        return nMonSinceFirstMolad;
    }

    public String[] Moon(int day, int month, int year, double latitude, double longitude, double deltahour) {
        this.RiseSet[0] = "--:--";
        this.RiseSet[1] = "--:--";
        if (day < 1 | day > 31 | month < 1 | month > 12 | year < 100) {
            this.RiseSet[0] = "Date error";
            this.RiseSet[1] = "Date error";
            return this.RiseSet;
        }
        if (year == 1582 & month == 10 & day > 4 & day < 15) {
            this.RiseSet[0] = "Date error";
            this.RiseSet[1] = "Date error";
            return this.RiseSet;
        }
        this.B5 = latitude;
        this.L5 = longitude;
        this.L5 /= 360.0;
        this.Z0 = -deltahour / 24.0;
        this.D = day;
        this.Mo = month;
        this.Y = year;
        this.x760();
        this.T = this.J - 2451545.0 + this.F;
        this.T0 = this.T / 36525.0;
        this.S = 24110.5 + 8640184.813 * this.T0;
        this.S += 86636.6 * this.Z0 + 86400.0 * this.L5;
        this.S /= 86400.0;
        this.S -= Math.floor(this.S);
        this.T0 = this.S * 360.0 * this.DtoR;
        this.T += this.Z0;
        int i = 1;
        while (i < 4) {
            this.x495();
            this.Ma[i][1] = this.A5;
            this.Ma[i][2] = this.D5;
            this.Ma[i][3] = this.R5;
            this.T += 0.5;
            ++i;
        }
        if (this.Ma[2][1] <= this.Ma[1][1]) {
            this.Ma[2][1] = this.Ma[2][1] + this.P2;
        }
        if (this.Ma[3][1] <= this.Ma[2][1]) {
            this.Ma[3][1] = this.Ma[3][1] + this.P2;
        }
        this.Z1 = this.DtoR * (90.567 - 41.685 / this.Ma[2][3]);
        this.S = Math.sin(this.B5 * this.DtoR);
        this.C = Math.cos(this.B5 * this.DtoR);
        this.Z = Math.cos(this.Z1);
        this.A0 = this.Ma[1][1];
        this.D0 = this.Ma[1][2];
        int Count = 0;
        while (Count < 24) {
            this.C0 = Count;
            this.P = (this.C0 + 1.0) / 24.0;
            this.F0 = this.Ma[1][1];
            this.F1 = this.Ma[2][1];
            this.F2 = this.Ma[3][1];
            this.A = this.F1 - this.F0;
            this.B = this.F2 - this.F1 - this.A;
            this.A2 = this.F0 + this.P * (2.0 * this.A + this.B * (2.0 * this.P - 1.0));
            this.F0 = this.Ma[1][2];
            this.F1 = this.Ma[2][2];
            this.F2 = this.Ma[3][2];
            this.A = this.F1 - this.F0;
            this.B = this.F2 - this.F1 - this.A;
            this.D2 = this.F0 + this.P * (2.0 * this.A + this.B * (2.0 * this.P - 1.0));
            this.L0 = this.T0 + this.C0 * this.K1;
            this.L2 = this.L0 + this.K1;
            if (this.A2 < this.A0) {
                this.A2 += this.P2;
            }
            this.H0 = this.L0 - this.A0;
            this.H2 = this.L2 - this.A2;
            this.H1 = (this.H2 + this.H0) / 2.0;
            this.D1 = (this.D2 + this.D0) / 2.0;
            if (this.C0 == 0.0) {
                this.V0 = this.S * Math.sin(this.D0) + this.C * Math.cos(this.D0) * Math.cos(this.H0) - this.Z;
            }
            this.V2 = this.S * Math.sin(this.D2) + this.C * Math.cos(this.D2) * Math.cos(this.H2) - this.Z;
            if (this.V0 / Math.abs(this.V0) != this.V2 / Math.abs(this.V2)) {
                this.V1 = this.S * Math.sin(this.D1) + this.C * Math.cos(this.D1) * Math.cos(this.H1) - this.Z;
                this.A = 2.0 * this.V2 - 4.0 * this.V1 + 2.0 * this.V0;
                this.B = 4.0 * this.V1 - 3.0 * this.V0 - this.V2;
                this.D = this.B * this.B - 4.0 * this.A * this.V0;
                if (this.D >= 0.0) {
                    String st2;
                    String st1;
                    this.D = Math.pow(this.D, 0.5);
                    if (this.V0 < 0.0 & this.V2 > 0.0) {
                        this.M8 = 1.0;
                    }
                    if (this.V0 > 0.0 & this.V2 < 0.0) {
                        this.W8 = 1.0;
                    }
                    this.E = (-this.B + this.D) / (2.0 * this.A);
                    if (this.E > 1.0 | this.E < 0.0) {
                        this.E = (-this.B - this.D) / (2.0 * this.A);
                    }
                    this.T3 = this.C0 + this.E + 0.0;
                    this.H3 = Math.floor(this.T3);
                    this.M3 = Math.floor((this.T3 - this.H3) * 60.0 + 0.5);
                    if (this.M3 == 60.0) {
                        this.H3 += 1.0;
                        this.M3 = 0.0;
                    }
                    if (this.V0 < 0.0 & this.V2 > 0.0) {
                        st1 = this.H3 < 10.0 ? "0" + Integer.toString((int)this.H3) : Integer.toString((int)this.H3);
                        st2 = this.M3 < 10.0 ? "0" + Integer.toString((int)this.M3) : Integer.toString((int)this.M3);
                        this.RiseSet[0] = String.valueOf(st1) + ":" + st2;
                    }
                    if (this.V0 > 0.0 & this.V2 < 0.0) {
                        st1 = this.H3 < 10.0 ? "0" + Integer.toString((int)this.H3) : Integer.toString((int)this.H3);
                        st2 = this.M3 < 10.0 ? "0" + Integer.toString((int)this.M3) : Integer.toString((int)this.M3);
                        this.RiseSet[1] = String.valueOf(st1) + ":" + st2;
                    }
                }
            }
            this.A0 = this.A2;
            this.D0 = this.D2;
            this.V0 = this.V2;
            ++Count;
        }
        if (this.M8 == 0.0 & this.W8 == 0.0) {
            if (this.V2 < 0.0) {
                this.RiseSet[0] = "--:--";
            }
            if (this.V2 > 0.0) {
                this.RiseSet[1] = "--:--";
            }
        } else {
            if (this.M8 == 0.0) {
                this.RiseSet[0] = "--:--";
            }
            if (this.W8 == 0.0) {
                this.RiseSet[1] = "--:--";
            }
        }
        this.M8 = 0.0;
        this.W8 = 0.0;
        return this.RiseSet;
    }

    private void x760() {
        double G = 1.0;
        if (this.Y < 1582.0) {
            G = 0.0;
        }
        this.D1 = this.D;
        this.F = this.D - this.D1 - 0.5;
        this.J = -Math.floor(7.0 * (Math.floor((this.Mo + 9.0) / 12.0) + this.Y) / 4.0);
        if (G != 0.0) {
            if (this.Mo != 9.0) {
                this.A = Math.abs(this.Mo - 9.0);
                this.S = (this.Mo - 9.0) / this.A;
                this.J3 = Math.floor(this.Y + this.S * Math.floor(this.A / 7.0));
            } else {
                this.J3 = this.Y;
            }
            this.J3 = Math.floor(this.J3 / 100.0);
            this.J3 = -Math.floor((this.J3 + 1.0) * 3.0 / 4.0);
        }
        this.J = this.J + Math.floor(275.0 * this.Mo / 9.0) + this.D1 + G * this.J3;
        this.J = this.J + 1721027.0 + 2.0 * G + 367.0 * this.Y;
        if (this.F >= 0.0) {
            this.F += 1.0;
            this.J -= 1.0;
        }
    }

    private void x495() {
        this.L = 0.606434 + 0.03660110129 * this.T;
        this.M = 0.374897 + 0.03629164709 * this.T;
        this.F = 0.259091 + 0.0367481952 * this.T;
        this.D = 0.827362 + 0.03386319198 * this.T;
        this.N = 0.347343 - 1.4709391E-4 * this.T;
        this.G = 0.993126 + 0.0027377785 * this.T;
        this.L -= Math.floor(this.L);
        this.M -= Math.floor(this.M);
        this.F -= Math.floor(this.F);
        this.D -= Math.floor(this.D);
        this.N -= Math.floor(this.N);
        this.G -= Math.floor(this.G);
        this.L *= this.P2;
        this.M *= this.P2;
        this.F *= this.P2;
        this.D *= this.P2;
        this.N *= this.P2;
        this.G *= this.P2;
        this.V = 0.39558 * Math.sin(this.F + this.N);
        this.V += 0.082 * Math.sin(this.F);
        this.V += 0.03257 * Math.sin(this.M - this.F - this.N);
        this.V += 0.01092 * Math.sin(this.M + this.F + this.N);
        this.V += 0.00666 * Math.sin(this.M - this.F);
        this.V -= 0.00644 * Math.sin(this.M + this.F - 2.0 * this.D + this.N);
        this.V -= 0.00331 * Math.sin(this.F - 2.0 * this.D + this.N);
        this.V -= 0.00304 * Math.sin(this.F - 2.0 * this.D);
        this.V -= 0.0024 * Math.sin(this.M - this.F - 2.0 * this.D - this.N);
        this.V += 0.00226 * Math.sin(this.M + this.F);
        this.V -= 0.00108 * Math.sin(this.M + this.F - 2.0 * this.D);
        this.V -= 7.9E-4 * Math.sin(this.F - this.N);
        this.V += 7.8E-4 * Math.sin(this.F + 2.0 * this.D + this.N);
        this.U = 1.0 - 0.10828 * Math.cos(this.M);
        this.U -= 0.0188 * Math.cos(this.M - 2.0 * this.D);
        this.U -= 0.01479 * Math.cos(2.0 * this.D);
        this.U += 0.00181 * Math.cos(2.0 * this.M - 2.0 * this.D);
        this.U -= 0.00147 * Math.cos(2.0 * this.M);
        this.U -= 0.00105 * Math.cos(2.0 * this.D - this.G);
        this.U -= 7.5E-4 * Math.cos(this.M - 2.0 * this.D + this.G);
        this.W = 0.10478 * Math.sin(this.M);
        this.W -= 0.04105 * Math.sin(2.0 * this.F + 2.0 * this.N);
        this.W -= 0.0213 * Math.sin(this.M - 2.0 * this.D);
        this.W -= 0.01779 * Math.sin(2.0 * this.F + this.N);
        this.W += 0.01774 * Math.sin(this.N);
        this.W += 0.00987 * Math.sin(2.0 * this.D);
        this.W -= 0.00338 * Math.sin(this.M - 2.0 * this.F - 2.0 * this.N);
        this.W -= 0.00309 * Math.sin(this.G);
        this.W -= 0.0019 * Math.sin(2.0 * this.F);
        this.W -= 0.00144 * Math.sin(this.M + this.N);
        this.W -= 0.00144 * Math.sin(this.M - 2.0 * this.F - this.N);
        this.W -= 0.00113 * Math.sin(this.M + 2.0 * this.F + 2.0 * this.N);
        this.W -= 9.4E-4 * Math.sin(this.M - 2.0 * this.D + this.G);
        this.W -= 9.2E-4 * Math.sin(2.0 * this.M - 2.0 * this.D);
        this.S = this.W / Math.pow(this.U - this.V * this.V, 0.5);
        this.A5 = this.L + Math.atan(this.S / Math.pow(1.0 - this.S * this.S, 0.5));
        this.S = this.V / Math.pow(this.U, 0.5);
        this.D5 = Math.atan(this.S / Math.pow(1.0 - this.S * this.S, 0.5));
        this.R5 = 60.40974 * Math.pow(this.U, 0.5);
    }

    public String[] Sun(int day, int month, int year, double latitude, double longitude, double deltahour) {
        if (day < 1 | day > 31 | month < 1 | month > 12 | year < 100) {
            this.RiseSet[0] = "Date error";
            this.RiseSet[1] = "Date error";
        } else if (year == 1582 & month == 10 & day > 4 & day < 15) {
            this.RiseSet[0] = "Date error";
            this.RiseSet[1] = "Date error";
        } else {
            int N1 = 275 * month / 9;
            int N2 = (int)Math.floor((month + 9) / 12);
            int N3 = (int)(1.0 + Math.floor(((double)year - 4.0 * Math.floor(year / 4) + 2.0) / 3.0));
            int N = N1 - N2 * N3 + day - 30;
            this.RiseSet[0] = this.tsun(0, N, latitude, longitude, deltahour);
            this.RiseSet[1] = this.tsun(1, N, latitude, longitude, deltahour);
        }
        return this.RiseSet;
    }

    private String tsun(int order, int N, double latit, double longit, double deltahour) {
        double RtoD = 57.29577951308232;
        double DtoR = Math.PI / 180;
        double lngHour = longit / 15.0;
        double t = (double)N + ((double)(6 + 12 * order) - lngHour) / 24.0;
        double M = 0.9856 * t - 3.289;
        double L = M + 1.916 * Math.sin(DtoR * M) + 0.02 * Math.sin(DtoR * 2.0 * M) + 282.634;
        L = (L + 720.0) % 360.0;
        double RA = RtoD * Math.atan(0.91764 * Math.tan(DtoR * L));
        RA = (RA + 720.0) % 360.0;
        double Lquadrant = Math.floor(L / 90.0) * 90.0;
        double RAquadrant = Math.floor(RA / 90.0) * 90.0;
        RA += Lquadrant - RAquadrant;
        RA = (RA + 720.0) % 360.0;
        RA /= 15.0;
        double sinDec = 0.39782 * Math.sin(DtoR * L);
        double cosDec = Math.cos(Math.asin(sinDec));
        double cosH = (Math.cos(DtoR * this.zenith) - sinDec * Math.sin(DtoR * latit)) / (cosDec * Math.cos(DtoR * latit));
        if (cosH > 1.0) {
            this.RiseSet[order] = "--:--";
        } else {
            double H = order == 0 ? 360.0 - RtoD * Math.acos(cosH) : RtoD * Math.acos(cosH);
            double TT = (H /= 15.0) + RA - 0.06571 * t - 6.622;
            double UT = TT - lngHour;
            double localT = (UT + deltahour + 48.0) % 24.0;
            int ht = (int)Math.floor(localT);
            double mint = Math.floor((localT - Math.floor(localT)) * 60.0 + 0.5);
            if (mint == 60.0) {
                ++ht;
                mint = 0.0;
            }
            String st1 = ht < 10 ? "0" + Integer.toString(ht) : Integer.toString(ht);
            String st2 = mint < 10.0 ? "0" + Integer.toString((int)mint) : Integer.toString((int)mint);
            this.RiseSet[order] = String.valueOf(st1) + ":" + st2;
            if (st2.length() == 1) {
                this.RiseSet[order] = "--:--";
            }
        }
        return this.RiseSet[order];
    }

    public double Julianday(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        long dt = DateTime.DateParse("01/01/1900");
        dt = DateTime.Add(dt, year - 1900, month - 1, day - 1);
        dt = (long)((double)dt + (((double)hour - deltahour) * 3600000.0 + (double)((long)minute * 60000L)));
        return (double)dt / 8.64E7 + 2440587.5;
    }

    public double Julianday2(long datetime, double deltahour) {
        long dt = datetime - (long)(deltahour * 3600000.0);
        return (double)dt / 8.64E7 + 2440587.5;
    }

    public double GetSunLong(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        return this.sunlong(this.Julianday(day, month, year, hour, minute, deltahour));
    }

    public double GetSunLong2(double julianday) {
        return this.sunlong(julianday);
    }

    private double sunlong(double jd) {
        double ts = (jd - 2451545.0 + 7.4074E-4) / 365.25;
        double l_sun = 280.4603 + 360.00769 * ts;
        l_sun += (1.9146 - 5.0E-5 * ts) * Math.sin((359.991 * ts + 357.538) * this.DtoR);
        l_sun += 0.02 * Math.sin((719.981 * ts + 355.05) * this.DtoR);
        l_sun += 0.0048 * Math.sin((19.341 * ts + 234.95) * this.DtoR);
        l_sun += 0.002 * Math.sin((329.64 * ts + 247.1) * this.DtoR);
        l_sun += 0.0018 * Math.sin((4452.67 * ts + 297.8) * this.DtoR);
        l_sun += 0.0018 * Math.sin((0.2 * ts + 251.3) * this.DtoR);
        l_sun += 0.0015 * Math.sin((450.37 * ts + 343.2) * this.DtoR);
        l_sun += 0.0013 * Math.sin((225.18 * ts + 81.4) * this.DtoR);
        l_sun += 8.0E-4 * Math.sin((659.29 * ts + 132.5) * this.DtoR);
        l_sun += 7.0E-4 * Math.sin((90.38 * ts + 153.3) * this.DtoR);
        l_sun += 7.0E-4 * Math.sin((30.35 * ts + 206.8) * this.DtoR);
        l_sun += 6.0E-4 * Math.sin((337.18 * ts + 29.8) * this.DtoR);
        l_sun += 5.0E-4 * Math.sin((1.5 * ts + 207.4) * this.DtoR);
        l_sun += 5.0E-4 * Math.sin((22.81 * ts + 291.2) * this.DtoR);
        l_sun += 4.0E-4 * Math.sin((315.56 * ts + 234.9) * this.DtoR);
        l_sun += 4.0E-4 * Math.sin((299.3 * ts + 157.3) * this.DtoR);
        l_sun += 4.0E-4 * Math.sin((720.02 * ts + 21.1) * this.DtoR);
        l_sun += 3.0E-4 * Math.sin((1079.97 * ts + 352.5) * this.DtoR);
        l_sun += 3.0E-4 * Math.sin((44.43 * ts + 329.7) * this.DtoR);
        if ((l_sun = (l_sun - Math.floor(l_sun / 360.0) * 360.0) * this.DtoR) < 0.0) {
            l_sun += this.P2;
        }
        return l_sun;
    }

    public double[] GetSunData(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        return this.sundata(this.Julianday(day, month, year, hour, minute, deltahour));
    }

    public double[] GetSunData2(double julianday) {
        return this.sundata(julianday);
    }

    private double[] sundata(double jd) {
        double[] data = new double[3];
        double ts = (jd - 2451545.0 + 7.4074E-4) / 365.25;
        double r_sun = (0.007256 - 2.0E-7 * ts) * Math.sin((359.991 * ts + 267.54) * this.DtoR);
        r_sun += 9.1E-5 * Math.sin((719.98 * ts + 265.1) * this.DtoR);
        r_sun += 3.0E-5 * Math.sin(90.0 * this.DtoR);
        r_sun += 1.3E-5 * Math.sin((4452.67 * ts + 27.8) * this.DtoR);
        r_sun += 7.0E-6 * Math.sin((450.4 * ts + 254.0) * this.DtoR);
        r_sun += 7.0E-6 * Math.sin((329.6 * ts + 156.0) * this.DtoR);
        data[0] = r_sun = Math.pow(10.0, r_sun);
        data[1] = 31.9876667 / r_sun;
        data[2] = -26.74 + 5.0 * Math.log10(r_sun * r_sun);
        return data;
    }

    public double GetMoonLong(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        return this.moonlong(this.Julianday(day, month, year, hour, minute, deltahour));
    }

    public double GetMoonLong2(double julianday) {
        return this.moonlong(julianday);
    }

    private double moonlong(double jd) {
        double ts = (jd - 2451545.0 + 7.4074E-4) / 36525.0;
        double l_moon = 218.3166 + 481267.8811 * ts - 0.0015 * ts * ts;
        l_moon += 6.2888 * Math.cos((477198.868 * ts + 44.963) * this.DtoR);
        l_moon += 1.274 * Math.cos((413335.35 * ts + 10.74) * this.DtoR);
        l_moon += 0.6583 * Math.cos((890534.22 * ts + 145.7) * this.DtoR);
        l_moon += 0.2136 * Math.cos((954397.74 * ts + 179.93) * this.DtoR);
        l_moon += 0.1851 * Math.cos((35999.05 * ts + 87.53) * this.DtoR);
        l_moon += 0.1144 * Math.cos((966404.0 * ts + 276.5) * this.DtoR);
        l_moon += 0.0588 * Math.cos((63863.5 * ts + 124.2) * this.DtoR);
        l_moon += 0.0571 * Math.cos((377336.3 * ts + 13.2) * this.DtoR);
        l_moon += 0.0533 * Math.cos((1367733.1 * ts + 280.7) * this.DtoR);
        l_moon += 0.0458 * Math.cos((854535.2 * ts + 148.2) * this.DtoR);
        l_moon += 0.0409 * Math.cos((441199.8 * ts + 47.4) * this.DtoR);
        l_moon += 0.0347 * Math.cos((445267.1 * ts + 27.9) * this.DtoR);
        l_moon += 0.0304 * Math.cos((513197.9 * ts + 222.5) * this.DtoR);
        l_moon += 0.0154 * Math.cos((75870.0 * ts + 41.0) * this.DtoR);
        l_moon += 0.0125 * Math.cos((1443603.0 * ts + 52.0) * this.DtoR);
        l_moon += 0.011 * Math.cos((489205.0 * ts + 142.0) * this.DtoR);
        l_moon += 0.0107 * Math.cos((1303870.0 * ts + 246.0) * this.DtoR);
        l_moon += 0.01 * Math.cos((1431597.0 * ts + 315.0) * this.DtoR);
        l_moon += 0.0085 * Math.cos((826671.0 * ts + 111.0) * this.DtoR);
        l_moon += 0.0079 * Math.cos((449334.0 * ts + 188.0) * this.DtoR);
        l_moon += 0.0068 * Math.cos((926533.0 * ts + 323.0) * this.DtoR);
        l_moon += 0.0052 * Math.cos((31932.0 * ts + 107.0) * this.DtoR);
        l_moon += 0.005 * Math.cos((481266.0 * ts + 205.0) * this.DtoR);
        l_moon += 0.004 * Math.cos((1331734.0 * ts + 283.0) * this.DtoR);
        l_moon += 0.004 * Math.cos((1844932.0 * ts + 56.0) * this.DtoR);
        l_moon += 0.004 * Math.cos((133.0 * ts + 29.0) * this.DtoR);
        l_moon += 0.0038 * Math.cos((1781068.0 * ts + 21.0) * this.DtoR);
        l_moon += 0.0037 * Math.cos((541062.0 * ts + 259.0) * this.DtoR);
        l_moon += 0.0028 * Math.cos((1934.0 * ts + 145.0) * this.DtoR);
        l_moon += 0.0027 * Math.cos((918399.0 * ts + 182.0) * this.DtoR);
        l_moon += 0.0026 * Math.cos((1379739.0 * ts + 17.0) * this.DtoR);
        l_moon += 0.0024 * Math.cos((99863.0 * ts + 122.0) * this.DtoR);
        l_moon += 0.0023 * Math.cos((922466.0 * ts + 163.0) * this.DtoR);
        l_moon += 0.0022 * Math.cos((818536.0 * ts + 151.0) * this.DtoR);
        l_moon += 0.0021 * Math.cos((990397.0 * ts + 357.0) * this.DtoR);
        l_moon += 0.0021 * Math.cos((71998.0 * ts + 85.0) * this.DtoR);
        l_moon += 0.0021 * Math.cos((341337.0 * ts + 16.0) * this.DtoR);
        l_moon += 0.0018 * Math.cos((401329.0 * ts + 274.0) * this.DtoR);
        l_moon += 0.0016 * Math.cos((1856938.0 * ts + 152.0) * this.DtoR);
        l_moon += 0.0012 * Math.cos((1267871.0 * ts + 249.0) * this.DtoR);
        l_moon += 0.0011 * Math.cos((1920802.0 * ts + 186.0) * this.DtoR);
        l_moon += 9.0E-4 * Math.cos((858602.0 * ts + 129.0) * this.DtoR);
        l_moon += 8.0E-4 * Math.cos((1403732.0 * ts + 98.0) * this.DtoR);
        l_moon += 7.0E-4 * Math.cos((790672.0 * ts + 114.0) * this.DtoR);
        l_moon += 7.0E-4 * Math.cos((405201.0 * ts + 50.0) * this.DtoR);
        l_moon += 7.0E-4 * Math.cos((485333.0 * ts + 186.0) * this.DtoR);
        l_moon += 7.0E-4 * Math.cos((27864.0 * ts + 127.0) * this.DtoR);
        l_moon += 6.0E-4 * Math.cos((111869.0 * ts + 38.0) * this.DtoR);
        l_moon += 6.0E-4 * Math.cos((2258267.0 * ts + 156.0) * this.DtoR);
        l_moon += 5.0E-4 * Math.cos((1908795.0 * ts + 90.0) * this.DtoR);
        l_moon += 5.0E-4 * Math.cos((1745069.0 * ts + 24.0) * this.DtoR);
        l_moon += 5.0E-4 * Math.cos((509131.0 * ts + 242.0) * this.DtoR);
        l_moon += 4.0E-4 * Math.cos((39871.0 * ts + 223.0) * this.DtoR);
        l_moon += 4.0E-4 * Math.cos((12006.0 * ts + 187.0) * this.DtoR);
        l_moon *= this.DtoR;
        if ((l_moon -= Math.floor(l_moon / this.P2) * this.P2) < 0.0) {
            l_moon += this.P2;
        }
        return l_moon;
    }

    public double GetMoonLat(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        return this.moonlat(this.Julianday(day, month, year, hour, minute, deltahour));
    }

    public double GetMoonLat2(double julianday) {
        return this.moonlat(julianday);
    }

    private double moonlat(double jd) {
        double ts = (jd - 2451545.0 + 7.4074E-4) / 36525.0;
        double b_moon = 5.1281 * Math.cos((483202.019 * ts + 3.273) * this.DtoR);
        b_moon += 0.2806 * Math.cos((960400.89 * ts + 138.24) * this.DtoR);
        b_moon += 0.2777 * Math.cos((6003.15 * ts + 48.31) * this.DtoR);
        b_moon += 0.1733 * Math.cos((407332.2 * ts + 52.43) * this.DtoR);
        b_moon += 0.0554 * Math.cos((896537.4 * ts + 104.0) * this.DtoR);
        b_moon += 0.0463 * Math.cos((69866.7 * ts + 82.5) * this.DtoR);
        b_moon += 0.0326 * Math.cos((1373736.2 * ts + 239.0) * this.DtoR);
        b_moon += 0.0172 * Math.cos((1437599.8 * ts + 273.2) * this.DtoR);
        b_moon += 0.0093 * Math.cos((884531.0 * ts + 187.0) * this.DtoR);
        b_moon += 0.0088 * Math.cos((471196.0 * ts + 87.0) * this.DtoR);
        b_moon += 0.0082 * Math.cos((371333.0 * ts + 55.0) * this.DtoR);
        b_moon += 0.0043 * Math.cos((547066.0 * ts + 217.0) * this.DtoR);
        b_moon += 0.0042 * Math.cos((1850935.0 * ts + 14.0) * this.DtoR);
        b_moon += 0.0034 * Math.cos((443331.0 * ts + 230.0) * this.DtoR);
        b_moon += 0.0025 * Math.cos((860538.0 * ts + 106.0) * this.DtoR);
        b_moon += 0.0022 * Math.cos((481268.0 * ts + 308.0) * this.DtoR);
        b_moon += 0.0022 * Math.cos((1337737.0 * ts + 241.0) * this.DtoR);
        b_moon += 0.0021 * Math.cos((105866.0 * ts + 80.0) * this.DtoR);
        b_moon += 0.0019 * Math.cos((924402.0 * ts + 141.0) * this.DtoR);
        b_moon += 0.0018 * Math.cos((820668.0 * ts + 153.0) * this.DtoR);
        b_moon += 0.0018 * Math.cos((519201.0 * ts + 181.0) * this.DtoR);
        b_moon += 0.0018 * Math.cos((1449606.0 * ts + 10.0) * this.DtoR);
        b_moon += 0.0015 * Math.cos((42002.0 * ts + 46.0) * this.DtoR);
        b_moon += 0.0015 * Math.cos((928469.0 * ts + 121.0) * this.DtoR);
        b_moon += 0.0015 * Math.cos((996400.0 * ts + 316.0) * this.DtoR);
        b_moon += 0.0014 * Math.cos((29996.0 * ts + 129.0) * this.DtoR);
        b_moon += 0.0013 * Math.cos((447203.0 * ts + 6.0) * this.DtoR);
        b_moon += 0.0013 * Math.cos((37935.0 * ts + 65.0) * this.DtoR);
        b_moon += 0.0011 * Math.cos((1914799.0 * ts + 48.0) * this.DtoR);
        b_moon += 0.001 * Math.cos((1297866.0 * ts + 288.0) * this.DtoR);
        b_moon += 9.0E-4 * Math.cos((1787072.0 * ts + 340.0) * this.DtoR);
        b_moon += 8.0E-4 * Math.cos((972407.0 * ts + 235.0) * this.DtoR);
        b_moon += 7.0E-4 * Math.cos((1309873.0 * ts + 205.0) * this.DtoR);
        b_moon += 6.0E-4 * Math.cos((559072.0 * ts + 134.0) * this.DtoR);
        b_moon += 6.0E-4 * Math.cos((1361730.0 * ts + 322.0) * this.DtoR);
        b_moon += 5.0E-4 * Math.cos((848532.0 * ts + 190.0) * this.DtoR);
        b_moon += 5.0E-4 * Math.cos((419339.0 * ts + 149.0) * this.DtoR);
        b_moon += 5.0E-4 * Math.cos((948395.0 * ts + 222.0) * this.DtoR);
        b_moon += 4.0E-4 * Math.cos((2328134.0 * ts + 149.0) * this.DtoR);
        b_moon += 4.0E-4 * Math.cos((1024264.0 * ts + 352.0) * this.DtoR);
        return b_moon *= this.DtoR;
    }

    public double GetMoonDistance(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        double temp = this.moondistance(this.Julianday(day, month, year, hour, minute, deltahour));
        return 6378.14 / Math.sin(temp);
    }

    public double GetMoonDistance2(double julianday) {
        double temp = this.moondistance(julianday);
        return 6378.14 / Math.sin(temp);
    }

    private double moondistance(double jd) {
        double ts = (jd - 2451545.0 + 7.4074E-4) / 36525.0;
        double p_moon = 0.950725;
        p_moon += 0.05182 * Math.cos((477198.868 * ts + 134.963) * this.DtoR);
        p_moon += 0.00953 * Math.cos((413335.35 * ts + 100.74) * this.DtoR);
        p_moon += 0.007842 * Math.cos((890534.22 * ts + 235.7) * this.DtoR);
        p_moon += 0.002824 * Math.cos((954397.74 * ts + 269.93) * this.DtoR);
        p_moon += 8.58E-4 * Math.cos((1367733.1 * ts + 10.7) * this.DtoR);
        p_moon += 5.31E-4 * Math.cos((854535.2 * ts + 238.2) * this.DtoR);
        p_moon += 4.0E-4 * Math.cos((377336.3 * ts + 103.2) * this.DtoR);
        p_moon += 3.19E-4 * Math.cos((441199.8 * ts + 137.4) * this.DtoR);
        p_moon += 2.71E-4 * Math.cos((445267.0 * ts + 118.0) * this.DtoR);
        p_moon += 2.63E-4 * Math.cos((513198.0 * ts + 312.0) * this.DtoR);
        p_moon += 1.97E-4 * Math.cos((489205.0 * ts + 232.0) * this.DtoR);
        p_moon += 1.73E-4 * Math.cos((1431597.0 * ts + 45.0) * this.DtoR);
        p_moon += 1.67E-4 * Math.cos((1303870.0 * ts + 336.0) * this.DtoR);
        p_moon += 1.11E-4 * Math.cos((35999.0 * ts + 178.0) * this.DtoR);
        p_moon += 1.03E-4 * Math.cos((826671.0 * ts + 201.0) * this.DtoR);
        p_moon += 8.4E-5 * Math.cos((63864.0 * ts + 214.0) * this.DtoR);
        p_moon += 8.3E-5 * Math.cos((926533.0 * ts + 53.0) * this.DtoR);
        p_moon += 7.8E-5 * Math.cos((1844932.0 * ts + 146.0) * this.DtoR);
        p_moon += 7.8E-5 * Math.cos((1781068.0 * ts + 111.0) * this.DtoR);
        p_moon += 6.4E-5 * Math.cos((1331734.0 * ts + 13.0) * this.DtoR);
        p_moon += 6.3E-5 * Math.cos((449334.0 * ts + 278.0) * this.DtoR);
        p_moon += 4.1E-5 * Math.cos((481266.0 * ts + 295.0) * this.DtoR);
        p_moon += 3.4E-5 * Math.cos((918399.0 * ts + 272.0) * this.DtoR);
        p_moon += 3.3E-5 * Math.cos((541062.0 * ts + 349.0) * this.DtoR);
        p_moon += 3.1E-5 * Math.cos((922466.0 * ts + 253.0) * this.DtoR);
        p_moon += 3.0E-5 * Math.cos((75870.0 * ts + 131.0) * this.DtoR);
        p_moon += 2.9E-5 * Math.cos((990397.0 * ts + 87.0) * this.DtoR);
        p_moon += 2.6E-5 * Math.cos((818536.0 * ts + 241.0) * this.DtoR);
        p_moon += 2.3E-5 * Math.cos((553069.0 * ts + 266.0) * this.DtoR);
        p_moon += 1.9E-5 * Math.cos((1267871.0 * ts + 339.0) * this.DtoR);
        p_moon += 1.3E-5 * Math.cos((1403732.0 * ts + 188.0) * this.DtoR);
        p_moon += 1.3E-5 * Math.cos((341337.0 * ts + 106.0) * this.DtoR);
        p_moon += 1.3E-5 * Math.cos((401329.0 * ts + 4.0) * this.DtoR);
        p_moon += 1.2E-5 * Math.cos((2258267.0 * ts + 246.0) * this.DtoR);
        p_moon += 1.1E-5 * Math.cos((1908795.0 * ts + 180.0) * this.DtoR);
        p_moon += 1.1E-5 * Math.cos((858602.0 * ts + 219.0) * this.DtoR);
        p_moon += 1.0E-5 * Math.cos((1745069.0 * ts + 114.0) * this.DtoR);
        return p_moon *= this.DtoR;
    }

    public double[] GetMoonData(int day, int month, int year, int hour, int minute, double deltahour) throws ParseException {
        return this.moondata(this.Julianday(day, month, year, hour, minute, deltahour));
    }

    public double[] GetMoonData2(double julianday) {
        return this.moondata(julianday);
    }

    private double[] moondata(double jd) {
        double mv_moon;
        double el_moon;
        double sd_moon;
        double ph;
        double[] data = new double[5];
        double lms = this.moonlong(jd) - this.sunlong(jd);
        double mage = lms - Math.floor(lms / this.P2) * this.P2;
        data[0] = ph = Math.acos(Math.cos(mage));
        data[1] = mage /= 0.21276871038558;
        data[2] = sd_moon = 0.272493 * this.moondistance(jd) * 120.0 / this.DtoR;
        data[3] = el_moon = Math.acos(Math.cos(this.moonlat(jd)) * Math.cos(lms));
        double phg = ph / this.DtoR;
        double ph4 = 180.0 - phg;
        ph4 = ph4 * ph4 * ph4 * ph4;
        data[4] = mv_moon = -12.73 + 0.026 * Math.abs(180.0 - phg) + 4.0E-9 * ph4;
        return data;
    }
}

